'##############################################################
'BeispielDS18S20.bas
'
'Ein  Programm fr die Universalplatine RN-AVR UNIVERSAL
'
'Das Programm zeigt wie man den 3 poligen Temperatursensor
'DS18S20 ausliest. Nach dem Aufruf wird die Temperatur alle 5 Sekunden
'ausgegen. Es knnen auch mehrere Sensoren auf einer Leitung
'angesprochen werden.
'
' (c) 2013 Frank
'Bezug fr Board und Sensor und DVD: www.robotikhardware.de
'Weitere Beispiele auf der Robotikhardware DVD oder
'im www.Roboternetz.de und rn-wissen.de
'######################################################################

'Portbelegung bzw. Modulverbindung
'PD3  Sensor Daten DS18S20      (nicht vergessen ein 4,7k Widerstand von PD3 nach +3,3V)
'GND  Sensor GND
'3V   Sensor 3V



Declare Sub Ds1820_seriennummer()
Declare Sub Ds1820_alleseriennummern()
Declare Sub Ds1820_temperatur_ausgeben()
Declare Sub Ds1820_sensor_temperatur()


$programmer = 12                                            'MCS USB  (Zeile weglassen wenn anderer Programmer)
$prog &HFF , &HFF , &HD9 , &HFE                             'Fusebits richtig programmieren (Quarz ein,Jtag aus)

$regfile = "m644pdef.dat"
$framesize = 32
$swstack = 32
$hwstack = 64

$crystal = 8000000                                          'QuarzFrequenzuenz
$baud = 9600
Baud = 9600



Config Pind.6 = Output                                      'LED
Led1 Alias Portd.6
Led1 = 0                                                    'ein

Config 1wire = Portd.3
Dim Sensordaten(9) As Byte
Dim Sensornummer(8) As Byte


Wait 2

Print "Beispielprogramm fuer RN-Avr Universal um Temperatur mit DS18S20 auszulesen"
Print "Serienummer notieren!"
Print "Einzelabruf:"
Ds1820_seriennummer
Print
Print "Falls es mehrere gibt, gleich alle abrufen::"
Ds1820_alleseriennummern
Print
Print "Temperatur ausgeben:"

Do
'  Ds1820_temperatur_ausgeben                               'Diese Funktion wenn nur ein Sensor am Bus
  Ds1820_sensor_temperatur                                  'Diese Funktion wenn man mehrere an gleicher
                                                            'Leitung hat und einen davon ansprechen mchte
  Wait 5
Loop




' ************ Hilfsfunktionen zur Kommunikation mit dem temperatursensor DS18S20 (c) Robotikhardware.de *********
'  (nhere Infos im Datenblatt des Sensors auf der www.Robotikhardeware.de DVD)
' Hilfreich auch der RN-Wissen Artikel unter http://www.rn-wissen.de/index.php/Bascom_und_1-Wire
' ************  **************  ************  ************** ************  ************** ************  **********


'Gibt die Seriennummer ber RS232 aus
'diese ist in jedem Sensor eindeutig vorhanden
'sie wird nur bentigt wenn mehrere Sensoren an einer Leitung hngen
Sub Ds1820_seriennummer()
Local I As Integer
Local Crc As Byte

   1wreset
   1wwrite &H33                                             ' ROM-Befehl zum lesen der SerienNr
   Sensornummer(1) = 1wread(8)                              ' 8 Bytes lesen
   Crc = Crc8(sensornummer(1) , 7)
   If Crc <> Sensornummer(8) Then Print "Daten fehlerhaft gelesen (CRC-Fehler)!"
   For I = 1 To 8
     Print Hex(sensornummer(i));                            ' Ausgeben
     Print " ";
   Next
   Print
End Sub


'Gibt die Seriennummer aller Sensoren an einem Bus ber RS232 aus
Sub Ds1820_alleseriennummern()
Local Crc As Byte
Local I As Integer
Local Anzahl As Integer

   Sensornummer(1) = 1wsearchfirst()
   If Err = 0 Then                                          'Wenn err, dann gibt es keinen Sensor
     Do
       Crc = Crc8(sensornummer(1) , 7)
       If Crc <> Sensornummer(8) Then Print "Daten fehlerhaft gelesen (CRC-Fehler)!"
       For I = 1 To 8
         Print Hex(sensornummer(i));
         Print " ";
       Next
       Print
       Sensornummer(1) = 1wsearchnext()                     'nchste suchen
     Loop Until Err = 1
   End If

   Print
   Anzahl == 1wirecount()                                   'Anzahl der Sensoren
   Print "Anzahl der Sensoren am Bus: " ; Anzahl
End Sub


'Diese Funktion gibt Temperaturbereich +85 bis -55 mit Vorzeichen auf ein halbes Grad genau aus
'Diese Funktion ist nur geeignet, wenn nur ein Sensor am Bus liegt
'Auf Fliekommazahlen wird verzichtet
Sub Ds1820_temperatur_ausgeben()
Local Temp As Integer
Local S As String * 5
Local Crc As Byte

   1wreset                                                  ' Initialisierung
   1wwrite &HCC                                             ' SKIP ROM
   1wwrite &H44                                             ' CONVERT T / Temperaturmessung starten
   Waitms 500                                               ' warten
   1wreset                                                  ' Initialisierung
   1wwrite &HCC                                             ' SKIP ROM
   1wwrite &HBE                                             ' READ SCRATCHPAD
   Sensordaten(1) = 1wread(9)                               ' Daten lesen
   Temp = Sensordaten(1)
   If Sensordaten(2) > 0 Then                               'Minus Temperatur
     Temp = 256 - Temp
     Temp = Temp * 10
     Temp = Temp / 2
     Temp = 0 - Temp                                        'Vorzeichen -
   Else
     Temp = Temp * 10
     Temp = Temp / 2
   End If

   S = Str(temp)
   Print
   Print Format(s , "0.0") ; "  Grad C"
   Crc = Crc8(sensordaten(1) , 8)
   If Crc <> Sensordaten(9) Then Print "Daten fehlerhaft gelesen (CRC-Fehler)!"
End Sub


'Diese Funktion macht das gleiche wie die Funktion Ds1820_temperatur_ausgeben
'Jedoch wird hier gezielt ein bestimmter Sensor angesprochen, es knnen also
'mehrere an der gleichen Leitung hngen
'Die Seriennummer des anzusprechenden Sensors muss vor dem Aufruf
'in das Array Sensornummer eingetragen werden
Sub Ds1820_sensor_temperatur()
Local Temp As Integer
Local S As String * 5
Local Crc As Byte

   1wverify Sensornummer(1)                                 'Seriennummer muss in Array Sensornummer stehen
   If Err = 0 Then
      1wwrite &H44
      Waitms 500                                            'warten
      1wverify Sensornummer(1)                              'Gert auswhlen
      1wwrite &HBE                                          'Temperatur lesen
      Sensordaten(1) = 1wread(9)                            'Daten lesen
    Else
       Print "Diesen Sensor nicht gefunden!"
    End If

   Temp = Sensordaten(1)
   If Sensordaten(2) > 0 Then                               'Minus Temperatur
     Temp = 256 - Temp
     Temp = Temp * 10
     Temp = Temp / 2
     Temp = 0 - Temp                                        'Vorzeichen -
   Else
     Temp = Temp * 10
     Temp = Temp / 2
   End If
   S = Str(temp)
   Print
   Print Format(s , "0.0") ; "  Grad C"
   Crc = Crc8(sensordaten(1) , 8)
   If Crc <> Sensordaten(9) Then Print "Daten fehlerhaft gelesen (CRC-Fehler)!"
End Sub